<?php
namespace ZS\Usaepay\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\Data\OrderPaymentInterface;

/**
 * Class Config
 * @package ZS\Usaepay\Helper
 */
class Config extends AbstractHelper
{
    const VISA 						= 'VI';
    const MASTERCARD 				= 'MC';
    const AMERICAN_EXPRESS 			= 'AE';

    const CONFIG_PCI_TOKENIZATION 	= 'tokenization';
    
    const CONFIG_PAYMENT_ACTION_AUTHORIZE = 'authorize';
    const CONFIG_PAYMENT_ACTION_AUTHORIZE_CAPTURE = 'authorize_capture';
    /**
     * @var \Magento\Framework\Encryption\EncryptorInterface
     */
    protected $encryptor;

    /**
     * Config constructor.
     * @param Context $context
     * @param \Magento\Framework\Encryption\EncryptorInterface $encryptor
     */
    public function __construct(
        Context $context,
        \Magento\Framework\Encryption\EncryptorInterface $encryptor
    ) {
        parent::__construct($context);
        $this->encryptor = $encryptor;
    }

    /**
     * @param $path
     * @return mixed
     */
    public function getConfigData($path)
    {
        return $this->scopeConfig->getValue('payment/zs_usaepay/'. $path);
    }
    /**
     * @return bool
     */
    public function isEnabled()
    {
        return !!$this->getConfigData('active');
    }
    /**
     * @return mixed
     */
    public function getSortOrder()
    {
        return $this->getConfigData('sort_order');
    }
    /**
     * @return bool
     */
    public function forceCvvForSavedCards()
    {
        return !!$this->getConfigData('force_cvv');
    }
    /**
     * @return bool
     */
    public function isTokenizationEnabled()
    {
        return $this->getConfigData('pci_compliance_method');
    }
}